/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Optional;
import org.apache.uniffle.client.api.ClientInfo;
import org.apache.uniffle.client.api.ShuffleServerClient;
import org.apache.uniffle.client.request.RssGetInMemoryShuffleDataRequest;
import org.apache.uniffle.client.response.RssGetInMemoryShuffleDataResponse;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.StorageType;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.storage.handler.impl.PrefetchableClientReadHandler;
import org.apache.uniffle.storage.handler.impl.ShuffleServerReadCostTracker;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryClientReadHandler
extends PrefetchableClientReadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryClientReadHandler.class);
    private long lastBlockId = -1L;
    private ShuffleServerClient shuffleServerClient;
    private Roaring64NavigableMap expectTaskIds;
    private int retryMax;
    private long retryIntervalMax;
    private ShuffleServerReadCostTracker readCostTracker;

    public MemoryClientReadHandler(String appId, int shuffleId, int partitionId, int readBufferSize, ShuffleServerClient shuffleServerClient, Roaring64NavigableMap expectTaskIds, int retryMax, long retryIntervalMax, Optional<PrefetchableClientReadHandler.PrefetchOption> prefetchOption, ShuffleServerReadCostTracker readCostTracker) {
        super(prefetchOption);
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionId = partitionId;
        this.readBufferSize = readBufferSize;
        this.shuffleServerClient = shuffleServerClient;
        this.expectTaskIds = expectTaskIds;
        this.retryMax = retryMax;
        this.retryIntervalMax = retryIntervalMax;
        this.readCostTracker = readCostTracker;
    }

    @VisibleForTesting
    public MemoryClientReadHandler(String appId, int shuffleId, int partitionId, int readBufferSize, ShuffleServerClient shuffleServerClient, Roaring64NavigableMap expectTaskIds) {
        this(appId, shuffleId, partitionId, readBufferSize, shuffleServerClient, expectTaskIds, 1, 0L, Optional.empty(), new ShuffleServerReadCostTracker());
    }

    @Override
    public ShuffleDataResult doReadShuffleData() {
        ShuffleDataResult result = null;
        RssGetInMemoryShuffleDataRequest request = new RssGetInMemoryShuffleDataRequest(this.appId, this.shuffleId, this.partitionId, this.lastBlockId, this.readBufferSize, this.expectTaskIds, this.retryMax, this.retryIntervalMax);
        try {
            long start = System.currentTimeMillis();
            RssGetInMemoryShuffleDataResponse response = this.shuffleServerClient.getInMemoryShuffleData(request);
            result = new ShuffleDataResult(response.getData(), response.getBufferSegments());
            ClientInfo clientInfo = this.shuffleServerClient.getClientInfo();
            if (this.readCostTracker != null && clientInfo != null) {
                this.readCostTracker.record(clientInfo.getShuffleServerInfo().getId(), StorageType.MEMORY, result.getDataLength(), System.currentTimeMillis() - start);
            }
        }
        catch (RssFetchFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RssFetchFailedException("Failed to read in memory shuffle data with " + this.shuffleServerClient.getClientInfo(), (Throwable)e);
        }
        if (!result.isEmpty()) {
            List bufferSegments = result.getBufferSegments();
            this.lastBlockId = ((BufferSegment)bufferSegments.get(bufferSegments.size() - 1)).getBlockId();
        }
        return result;
    }
}

