/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client;

import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.uniffle.client.RestClientConf;
import org.apache.uniffle.client.exception.UniffleRestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientFactory.class);

    public static CloseableHttpClient createHttpClient(RestClientConf conf) {
        SSLConnectionSocketFactory sslSocketFactory;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(conf.getSocketTimeout()).setConnectTimeout(conf.getConnectTimeout()).build();
        try {
            SSLContext sslContext = SSLContexts.createSystemDefault();
            sslSocketFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        }
        catch (Exception e) {
            LOG.error("Error: ", (Throwable)e);
            throw new UniffleRestException("Failed to create HttpClient", e);
        }
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
    }
}

