/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.request;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.uniffle.common.ShuffleReadTimes;
import org.apache.uniffle.proto.RssProtos;

public class RssReportShuffleReadMetricRequest {
    private int stageId;
    private int shuffleId;
    private long taskId;
    private Map<String, TaskShuffleReadMetric> metrics;
    private boolean isShuffleReadFailed;
    private Optional<String> shuffleReadReason;
    private ShuffleReadTimes shuffleReadTimes;

    public RssReportShuffleReadMetricRequest(int stageId, int shuffleId, long taskId, Map<String, TaskShuffleReadMetric> metrics, boolean isShuffleReadFailed, Optional<String> shuffleReadReason, ShuffleReadTimes shuffleReadTimes) {
        this.stageId = stageId;
        this.shuffleId = shuffleId;
        this.taskId = taskId;
        this.metrics = metrics;
        this.isShuffleReadFailed = isShuffleReadFailed;
        this.shuffleReadReason = shuffleReadReason;
        this.shuffleReadTimes = shuffleReadTimes;
    }

    public RssProtos.ReportShuffleReadMetricRequest toProto() {
        RssReportShuffleReadMetricRequest request = this;
        RssProtos.ReportShuffleReadMetricRequest.Builder builder = RssProtos.ReportShuffleReadMetricRequest.newBuilder();
        builder.setShuffleId(request.shuffleId).setStageId(request.stageId).setTaskId(request.taskId).setIsTaskReadFailed(request.isShuffleReadFailed).setShuffleReadFailureReason(request.shuffleReadReason.orElse("")).setShuffleReadTimes(this.shuffleReadTimes.toProto()).putAllMetrics(request.metrics.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> RssProtos.ShuffleReadMetric.newBuilder().setByteSize(((TaskShuffleReadMetric)x.getValue()).getByteSize()).setDurationMillis(((TaskShuffleReadMetric)x.getValue()).getDurationMillis()).setMemoryByteSize(((TaskShuffleReadMetric)x.getValue()).getMemoryByteSize()).setMemoryDurationMillis(((TaskShuffleReadMetric)x.getValue()).getMemoryDurationMillis()).setLocalfileByteSize(((TaskShuffleReadMetric)x.getValue()).getLocalfileByteSize()).setLocalfileDurationMillis(((TaskShuffleReadMetric)x.getValue()).getLocalfileDurationMillis()).setHadoopByteSize(((TaskShuffleReadMetric)x.getValue()).getHadoopByteSize()).setHadoopDurationMillis(((TaskShuffleReadMetric)x.getValue()).getHadoopDurationMillis()).build())));
        return builder.build();
    }

    public static class TaskShuffleReadMetric {
        private long durationMillis;
        private long byteSize;
        private long localfileByteSize;
        private long localfileDurationMillis;
        private long memoryByteSize;
        private long memoryDurationMillis;
        private long hadoopByteSize;
        private long hadoopDurationMillis;

        public TaskShuffleReadMetric(long durationMillis, long byteSize, long memoryReadDurationMillis, long memoryReadBytes, long localfileReadDurationMillis, long localfileReadBytes, long hadoopReadLocalFileDurationMillis, long hadoopReadLocalFileBytes) {
            this.durationMillis = durationMillis;
            this.byteSize = byteSize;
            this.localfileByteSize = localfileReadBytes;
            this.localfileDurationMillis = localfileReadDurationMillis;
            this.memoryByteSize = memoryReadBytes;
            this.memoryDurationMillis = memoryReadDurationMillis;
            this.hadoopByteSize = hadoopReadLocalFileBytes;
            this.hadoopDurationMillis = hadoopReadLocalFileDurationMillis;
        }

        public long getDurationMillis() {
            return this.durationMillis;
        }

        public long getByteSize() {
            return this.byteSize;
        }

        public long getLocalfileByteSize() {
            return this.localfileByteSize;
        }

        public long getLocalfileDurationMillis() {
            return this.localfileDurationMillis;
        }

        public long getMemoryByteSize() {
            return this.memoryByteSize;
        }

        public long getMemoryDurationMillis() {
            return this.memoryDurationMillis;
        }

        public long getHadoopByteSize() {
            return this.hadoopByteSize;
        }

        public long getHadoopDurationMillis() {
            return this.hadoopDurationMillis;
        }
    }
}

