/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.executor;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;

public class MeasurableRejectedExecutionHandler
implements RejectedExecutionHandler {
    private AtomicLong counter = new AtomicLong(0L);
    private final RejectedExecutionHandler handler;

    public MeasurableRejectedExecutionHandler(RejectedExecutionHandler handler) {
        this.handler = handler;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        this.counter.incrementAndGet();
        if (this.handler != null) {
            this.handler.rejectedExecution(r, executor);
        }
    }

    public long getCount() {
        return this.counter.get();
    }
}

