/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.storage.handler.ClientReadHandlerMetric;
import org.apache.uniffle.storage.handler.api.ClientReadHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientReadHandler
implements ClientReadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientReadHandler.class);
    protected String appId;
    protected int shuffleId;
    protected int partitionId;
    protected int readBufferSize;
    protected ClientReadHandlerMetric readHandlerMetric = new ClientReadHandlerMetric();

    @Override
    public ShuffleDataResult readShuffleData() {
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public void updateConsumedBlockInfo(BufferSegment bs, boolean isSkippedMetrics) {
        if (bs == null) {
            return;
        }
        this.updateBlockMetric(this.readHandlerMetric, bs, isSkippedMetrics);
    }

    @Override
    public void logConsumedBlockInfo() {
        LOG.info("Client read [" + this.readHandlerMetric.getReadBlockNum() + " blocks, bytes:" + this.readHandlerMetric.getReadLength() + " uncompressed bytes:" + this.readHandlerMetric.getReadUncompressLength() + "], skipped[" + this.readHandlerMetric.getSkippedReadBlockNum() + " blocks, bytes:" + this.readHandlerMetric.getSkippedReadLength() + " uncompressed bytes:" + this.readHandlerMetric.getSkippedReadUncompressLength() + "]");
    }

    protected void updateBlockMetric(ClientReadHandlerMetric metric, BufferSegment bs, boolean isSkippedMetrics) {
        if (isSkippedMetrics) {
            metric.incSkippedReadBlockNum();
            metric.incSkippedReadLength(bs.getLength());
            metric.incSkippedReadUncompressLength(bs.getUncompressLength());
        } else {
            metric.incReadBlockNum();
            metric.incReadLength(bs.getLength());
            metric.incReadUncompressLength(bs.getUncompressLength());
        }
    }

    public ClientReadHandlerMetric getReadHandlerMetric() {
        return this.readHandlerMetric;
    }
}

