/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.executor.ShuffleReadMetrics;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.rdd.DeterministicLevel;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.shuffle.RssShuffleHandle;
import org.apache.spark.shuffle.RssSparkConfig;
import org.apache.spark.shuffle.RssSparkShuffleUtils;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.Spark3VersionUtils;
import org.apache.spark.shuffle.events.ShuffleAssignmentInfoEvent;
import org.apache.spark.shuffle.handle.MutableShuffleHandleInfo;
import org.apache.spark.shuffle.handle.ShuffleHandleInfo;
import org.apache.spark.shuffle.handle.ShuffleHandleInfoBase;
import org.apache.spark.shuffle.handle.SimpleShuffleHandleInfo;
import org.apache.spark.shuffle.handle.StageAttemptShuffleHandleInfo;
import org.apache.spark.shuffle.reader.RssShuffleReader;
import org.apache.spark.shuffle.writer.DataPusher;
import org.apache.spark.shuffle.writer.RssShuffleWriter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.storage.BlockManagerId;
import org.apache.uniffle.client.PartitionDataReplicaRequirementTracking;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.factory.ShuffleClientFactory;
import org.apache.uniffle.client.impl.FailedBlockSendTracker;
import org.apache.uniffle.client.util.ClientUtils;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Sets;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.apache.uniffle.shuffle.RssShuffleClientFactory;
import org.apache.uniffle.shuffle.manager.RssShuffleManagerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.collection.Iterator;

public class RssShuffleManager
extends RssShuffleManagerBase {
    private static final Logger LOG = LoggerFactory.getLogger(RssShuffleManager.class);

    public RssShuffleManager(SparkConf conf, boolean isDriver) {
        super(conf, isDriver);
        this.dataDistributionType = RssShuffleManager.getDataDistributionType(this.sparkConf);
    }

    @VisibleForTesting
    RssShuffleManager(SparkConf conf, boolean isDriver, DataPusher dataPusher, Map<String, Set<Long>> taskToSuccessBlockIds, Map<String, FailedBlockSendTracker> taskToFailedBlockSendTracker) {
        super(conf, isDriver, dataPusher, taskToSuccessBlockIds, taskToFailedBlockSendTracker);
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, ShuffleDependency<K, V, C> dependency) {
        MutableShuffleHandleInfo shuffleHandleInfo;
        if (dependency.partitioner().numPartitions() > this.blockIdLayout.maxNumPartitions) {
            throw new RssException("Cannot register shuffle with " + dependency.partitioner().numPartitions() + " partitions because the configured block id layout supports at most " + this.blockIdLayout.maxNumPartitions + " partitions.");
        }
        if (!SparkEnv.get().serializer().supportsRelocationOfSerializedObjects()) {
            throw new IllegalArgumentException("Can't use serialized shuffle for shuffleId: " + shuffleId + ", because the serializer: " + SparkEnv.get().serializer().getClass().getName() + " does not support object relocation.");
        }
        if (this.id.get() == null) {
            this.id.compareAndSet(null, SparkEnv.get().conf().getAppId() + "_" + this.uuid);
            this.appId = (String)this.id.get();
            this.dataPusher.setRssAppId((String)this.id.get());
        }
        LOG.info("Generate application id used in rss: " + (String)this.id.get());
        if (this.rssStageRetryEnabled) {
            this.shuffleIdMappingManager.recordShuffleIdDeterminate(shuffleId, dependency.rdd().getOutputDeterministicLevel() != DeterministicLevel.INDETERMINATE());
        }
        if (dependency.partitioner().numPartitions() == 0) {
            this.shuffleIdToPartitionNum.putIfAbsent(shuffleId, 0);
            this.shuffleIdToNumMapTasks.computeIfAbsent(shuffleId, key -> dependency.rdd().partitions().length);
            LOG.info("RegisterShuffle with ShuffleId[{}], partitionNum is 0, return the empty RssShuffleHandle directly", (Object)shuffleId);
            Broadcast<SimpleShuffleHandleInfo> hdlInfoBd = RssSparkShuffleUtils.broadcastShuffleHdlInfo(RssSparkShuffleUtils.getActiveSparkContext(), shuffleId, Collections.emptyMap(), RemoteStorageInfo.EMPTY_REMOTE_STORAGE);
            return new RssShuffleHandle<K, V, C>(shuffleId, (String)this.id.get(), dependency.rdd().getNumPartitions(), dependency, hdlInfoBd);
        }
        String storageType = this.sparkConf.get(RssSparkConfig.RSS_STORAGE_TYPE.key());
        RemoteStorageInfo defaultRemoteStorage = RssShuffleManager.getDefaultRemoteStorageInfo(this.sparkConf);
        RemoteStorageInfo remoteStorage = ClientUtils.fetchRemoteStorage((String)this.id.get(), defaultRemoteStorage, this.dynamicConfEnabled, storageType, this.shuffleWriteClient);
        Set<String> assignmentTags = RssSparkShuffleUtils.getAssignmentTags(this.sparkConf);
        ClientUtils.validateClientType(this.clientType);
        assignmentTags.add(this.clientType);
        int requiredShuffleServerNumber = RssSparkShuffleUtils.getRequiredShuffleServerNumber(this.sparkConf);
        int estimateTaskConcurrency = RssSparkShuffleUtils.estimateTaskConcurrency(this.sparkConf);
        Map<Integer, List<ShuffleServerInfo>> partitionToServers = this.requestShuffleAssignment(shuffleId, dependency.partitioner().numPartitions(), 1, requiredShuffleServerNumber, estimateTaskConcurrency, this.rssStageResubmitManager.getServerIdBlackList());
        this.startHeartbeat();
        this.shuffleIdToPartitionNum.computeIfAbsent(shuffleId, key -> dependency.partitioner().numPartitions());
        this.shuffleIdToNumMapTasks.computeIfAbsent(shuffleId, key -> dependency.rdd().partitions().length);
        if (this.shuffleManagerRpcServiceEnabled && this.rssStageRetryForWriteFailureEnabled) {
            shuffleHandleInfo = new MutableShuffleHandleInfo(shuffleId, partitionToServers, remoteStorage, this.partitionSplitMode);
            StageAttemptShuffleHandleInfo handleInfo = new StageAttemptShuffleHandleInfo(shuffleId, remoteStorage, shuffleHandleInfo);
            this.shuffleHandleInfoManager.register(shuffleId, handleInfo);
        } else if (this.shuffleManagerRpcServiceEnabled && this.partitionReassignEnabled) {
            shuffleHandleInfo = new MutableShuffleHandleInfo(shuffleId, partitionToServers, remoteStorage, this.partitionSplitMode);
            this.shuffleHandleInfoManager.register(shuffleId, shuffleHandleInfo);
        }
        Broadcast<SimpleShuffleHandleInfo> hdlInfoBd = RssSparkShuffleUtils.broadcastShuffleHdlInfo(RssSparkShuffleUtils.getActiveSparkContext(), shuffleId, partitionToServers, remoteStorage);
        LOG.info("RegisterShuffle with ShuffleId[{}], uniffleShuffleId[{}], partitionNum[{}], shuffleServerForResult: {}", new Object[]{shuffleId, shuffleId, partitionToServers.size(), partitionToServers});
        RssSparkShuffleUtils.getActiveSparkContext().listenerBus().post((SparkListenerEvent)new ShuffleAssignmentInfoEvent(shuffleId, new ArrayList<String>(partitionToServers.values().stream().flatMap(x -> x.stream()).map(x -> x.getId()).collect(Collectors.toSet()))));
        return new RssShuffleHandle<K, V, C>(shuffleId, (String)this.id.get(), dependency.rdd().getNumPartitions(), dependency, hdlInfoBd);
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, long mapId, TaskContext context, ShuffleWriteMetricsReporter metrics) {
        if (!(handle instanceof RssShuffleHandle)) {
            throw new RssException("Unexpected ShuffleHandle:" + handle.getClass().getName());
        }
        RssShuffleHandle rssHandle = (RssShuffleHandle)handle;
        this.setPusherAppId(rssHandle);
        int shuffleId = rssHandle.getShuffleId();
        ShuffleWriteMetrics writeMetrics = metrics != null ? new WriteMetrics(metrics) : context.taskMetrics().shuffleWriteMetrics();
        String taskId = "" + context.taskAttemptId() + "_" + context.attemptNumber();
        return new RssShuffleWriter(rssHandle.getAppId(), shuffleId, taskId, this.getTaskAttemptIdForBlockId(context.partitionId(), context.attemptNumber()), writeMetrics, this, this.sparkConf, this.shuffleWriteClient, this.managerClientSupplier, rssHandle, this::markFailedTask, context);
    }

    public void setPusherAppId(RssShuffleHandle rssShuffleHandle) {
        if (this.id.get() == null) {
            this.id.compareAndSet(null, rssShuffleHandle.getAppId());
            this.dataPusher.setRssAppId((String)this.id.get());
        }
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        return this.getReader(handle, 0, Integer.MAX_VALUE, startPartition, endPartition, context, metrics);
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        long start = System.currentTimeMillis();
        Roaring64NavigableMap taskIdBitmap = this.getExpectedTasksByExecutorId(handle.shuffleId(), startPartition, endPartition, startMapIndex, endMapIndex);
        LOG.info("Get taskId cost " + (System.currentTimeMillis() - start) + " ms, and request expected blockIds from " + taskIdBitmap.getLongCardinality() + " tasks for shuffleId[" + handle.shuffleId() + "], partitionId[" + startPartition + ", " + endPartition + "]");
        return this.getReaderImpl(handle, startMapIndex, endMapIndex, startPartition, endPartition, context, metrics, taskIdBitmap);
    }

    public <K, C> ShuffleReader<K, C> getReaderForRange(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        long start = System.currentTimeMillis();
        Roaring64NavigableMap taskIdBitmap = this.getExpectedTasksByRange(handle.shuffleId(), startPartition, endPartition, startMapIndex, endMapIndex);
        LOG.info("Get taskId cost " + (System.currentTimeMillis() - start) + " ms, and request expected blockIds from " + taskIdBitmap.getLongCardinality() + " tasks for shuffleId[" + handle.shuffleId() + "], partitionId[" + startPartition + ", " + endPartition + "]");
        return this.getReaderImpl(handle, startMapIndex, endMapIndex, startPartition, endPartition, context, metrics, taskIdBitmap);
    }

    public <K, C> ShuffleReader<K, C> getReaderImpl(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics, Roaring64NavigableMap taskIdBitmap) {
        if (!(handle instanceof RssShuffleHandle)) {
            throw new RssException("Unexpected ShuffleHandle:" + handle.getClass().getName());
        }
        RssShuffleHandle rssShuffleHandle = (RssShuffleHandle)handle;
        int partitionNum = rssShuffleHandle.getDependency().partitioner().numPartitions();
        int shuffleId = rssShuffleHandle.getShuffleId();
        ShuffleHandleInfoBase shuffleHandleInfo = this.shuffleManagerRpcServiceEnabled && this.rssStageRetryForWriteFailureEnabled ? this.getRemoteShuffleHandleInfoWithStageRetry(context.stageId(), context.stageAttemptNumber(), shuffleId, false) : (this.shuffleManagerRpcServiceEnabled && this.partitionReassignEnabled ? this.getRemoteShuffleHandleInfoWithBlockRetry(context.stageId(), context.stageAttemptNumber(), shuffleId, false) : new SimpleShuffleHandleInfo(shuffleId, rssShuffleHandle.getPartitionToServers(), rssShuffleHandle.getRemoteStorage()));
        Map<ShuffleServerInfo, Set<Integer>> serverToPartitions = this.getPartitionDataServers(shuffleHandleInfo, startPartition, endPartition);
        long start = System.currentTimeMillis();
        Roaring64NavigableMap blockIdBitmap = this.getShuffleResultForMultiPart(this.clientType, serverToPartitions, rssShuffleHandle.getAppId(), shuffleId, context.stageAttemptNumber(), shuffleHandleInfo.createPartitionReplicaTracking());
        LOG.info("Get shuffle blockId cost " + (System.currentTimeMillis() - start) + " ms, and get " + blockIdBitmap.getLongCardinality() + " blockIds for shuffleId[" + shuffleId + "], startPartition[" + startPartition + "], endPartition[" + endPartition + "]");
        ShuffleReadMetrics readMetrics = metrics != null ? new ReadMetrics(metrics) : context.taskMetrics().shuffleReadMetrics();
        RemoteStorageInfo shuffleRemoteStorageInfo = rssShuffleHandle.getRemoteStorage();
        LOG.info("Shuffle reader using remote storage {}", (Object)shuffleRemoteStorageInfo);
        String shuffleRemoteStoragePath = shuffleRemoteStorageInfo.getPath();
        Configuration readerHadoopConf = RssSparkShuffleUtils.getRemoteStorageHadoopConf(this.sparkConf, shuffleRemoteStorageInfo);
        return new RssShuffleReader(startPartition, endPartition, startMapIndex, endMapIndex, context, rssShuffleHandle, shuffleRemoteStoragePath, readerHadoopConf, partitionNum, RssUtils.generatePartitionToBitmap(blockIdBitmap, startPartition, endPartition, this.blockIdLayout), taskIdBitmap, readMetrics, this.managerClientSupplier, RssSparkConfig.toRssConf(this.sparkConf), this.dataDistributionType, shuffleHandleInfo.getAllPartitionServersForReader());
    }

    private Map<ShuffleServerInfo, Set<Integer>> getPartitionDataServers(ShuffleHandleInfo shuffleHandleInfo, int startPartition, int endPartition) {
        Map<Integer, List<ShuffleServerInfo>> allPartitionToServers = shuffleHandleInfo.getAllPartitionServersForReader();
        Map<Integer, List<ShuffleServerInfo>> requirePartitionToServers = allPartitionToServers.entrySet().stream().filter(x -> (Integer)x.getKey() >= startPartition && (Integer)x.getKey() < endPartition).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<ShuffleServerInfo, Set<Integer>> serverToPartitions = RssUtils.generateServerToPartitions(requirePartitionToServers);
        return serverToPartitions;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private Roaring64NavigableMap getExpectedTasksByExecutorId(int shuffleId, int startPartition, int endPartition, int startMapIndex, int endMapIndex) {
        Roaring64NavigableMap taskIdBitmap = Roaring64NavigableMap.bitmapOf(new long[0]);
        Iterator mapStatusIter = null;
        try {
            mapStatusIter = Spark3VersionUtils.MAJOR_VERSION > 3 || Spark3VersionUtils.MINOR_VERSION > 2 || Spark3VersionUtils.MINOR_VERSION == 2 && !Spark3VersionUtils.isSpark320() || Spark3VersionUtils.MINOR_VERSION == 1 ? (Iterator)SparkEnv.get().mapOutputTracker().getClass().getDeclaredMethod("getMapSizesByExecutorId", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke((Object)SparkEnv.get().mapOutputTracker(), shuffleId, startMapIndex, endMapIndex, startPartition, endPartition) : (Spark3VersionUtils.isSpark320() ? (Iterator)MapOutputTracker.class.getDeclaredMethod("getMapSizesByExecutorId", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke((Object)SparkEnv.get().mapOutputTracker(), shuffleId, startMapIndex, endMapIndex, startPartition, endPartition) : (Iterator)SparkEnv.get().mapOutputTracker().getClass().getDeclaredMethod("getMapSizesByExecutorId", Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke((Object)SparkEnv.get().mapOutputTracker(), shuffleId, startPartition, endPartition));
        }
        catch (Exception e) {
            throw new RssException(e);
        }
        while (mapStatusIter.hasNext()) {
            Tuple2 tuple2 = (Tuple2)mapStatusIter.next();
            if (!((BlockManagerId)tuple2._1()).topologyInfo().isDefined()) {
                throw new RssException("Can't get expected taskAttemptId");
            }
            taskIdBitmap.add(Long.parseLong((String)((BlockManagerId)tuple2._1()).topologyInfo().get()));
        }
        return taskIdBitmap;
    }

    private Roaring64NavigableMap getExpectedTasksByRange(int shuffleId, int startPartition, int endPartition, int startMapIndex, int endMapIndex) {
        Roaring64NavigableMap taskIdBitmap = Roaring64NavigableMap.bitmapOf(new long[0]);
        Iterator mapStatusIter = null;
        try {
            mapStatusIter = (Iterator)SparkEnv.get().mapOutputTracker().getClass().getDeclaredMethod("getMapSizesByRange", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke((Object)SparkEnv.get().mapOutputTracker(), shuffleId, startMapIndex, endMapIndex, startPartition, endPartition);
        }
        catch (Exception e) {
            throw new RssException(e);
        }
        while (mapStatusIter.hasNext()) {
            Tuple2 tuple2 = (Tuple2)mapStatusIter.next();
            if (!((BlockManagerId)tuple2._1()).topologyInfo().isDefined()) {
                throw new RssException("Can't get expected taskAttemptId");
            }
            taskIdBitmap.add(Long.parseLong((String)((BlockManagerId)tuple2._1()).topologyInfo().get()));
        }
        return taskIdBitmap;
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        throw new RssException("RssShuffleManager.shuffleBlockResolver is not implemented");
    }

    @Override
    protected ShuffleWriteClient createShuffleWriteClient() {
        int unregisterThreadPoolSize = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_UNREGISTER_THREAD_POOL_SIZE);
        int unregisterTimeoutSec = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_UNREGISTER_TIMEOUT_SEC);
        int unregisterRequestTimeoutSec = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_UNREGISTER_REQUEST_TIMEOUT_SEC);
        long retryIntervalMax = (Long)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_RETRY_INTERVAL_MAX);
        int heartBeatThreadNum = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_HEARTBEAT_THREAD_NUM);
        int retryMax = (Integer)this.sparkConf.get(RssSparkConfig.RSS_CLIENT_RETRY_MAX);
        return RssShuffleClientFactory.getInstance().createShuffleWriteClient((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)((ShuffleClientFactory.WriteClientBuilder)((RssShuffleClientFactory.ExtendWriteClientBuilder)RssShuffleClientFactory.newWriteBuilder().blockIdSelfManagedEnabled(this.blockIdSelfManagedEnabled)).managerClientSupplier(this.managerClientSupplier)).clientType(this.clientType)).retryMax(retryMax)).retryIntervalMax(retryIntervalMax)).heartBeatThreadNum(heartBeatThreadNum)).replica(this.dataReplica)).replicaWrite(this.dataReplicaWrite)).replicaRead(this.dataReplicaRead)).replicaSkipEnabled(this.dataReplicaSkipEnabled)).dataTransferPoolSize(this.dataTransferPoolSize)).dataCommitPoolSize(this.dataCommitPoolSize)).unregisterThreadPoolSize(unregisterThreadPoolSize)).unregisterTimeSec(unregisterTimeoutSec)).unregisterRequestTimeSec(unregisterRequestTimeoutSec)).rssConf(this.rssConf));
    }

    @VisibleForTesting
    protected static ShuffleDataDistributionType getDataDistributionType(SparkConf sparkConf) {
        RssConf rssConf = RssSparkConfig.toRssConf(sparkConf);
        if (((Boolean)sparkConf.get(SQLConf.ADAPTIVE_EXECUTION_ENABLED())).booleanValue() && !rssConf.containsKey(RssClientConf.DATA_DISTRIBUTION_TYPE.key())) {
            return ShuffleDataDistributionType.LOCAL_ORDER;
        }
        return rssConf.get(RssClientConf.DATA_DISTRIBUTION_TYPE);
    }

    @VisibleForTesting
    public void setAppId(String appId) {
        this.id = new AtomicReference<String>(appId);
    }

    private Roaring64NavigableMap getShuffleResultForMultiPart(String clientType, Map<ShuffleServerInfo, Set<Integer>> serverToPartitions, String appId, int shuffleId, int stageAttemptId, PartitionDataReplicaRequirementTracking replicaRequirementTracking) {
        HashSet<Integer> failedPartitions = Sets.newHashSet();
        try {
            return this.shuffleWriteClient.getShuffleResultForMultiPart(clientType, serverToPartitions, appId, shuffleId, failedPartitions, replicaRequirementTracking);
        }
        catch (RssFetchFailedException e) {
            throw RssSparkShuffleUtils.reportRssFetchFailedException(this.managerClientSupplier, e, this.sparkConf, appId, shuffleId, stageAttemptId, failedPartitions);
        }
    }

    public static class WriteMetrics
    extends ShuffleWriteMetrics {
        private ShuffleWriteMetricsReporter reporter;

        public WriteMetrics(ShuffleWriteMetricsReporter reporter) {
            this.reporter = reporter;
        }

        public void incBytesWritten(long v) {
            this.reporter.incBytesWritten(v);
        }

        public void incRecordsWritten(long v) {
            this.reporter.incRecordsWritten(v);
        }

        public void incWriteTime(long v) {
            this.reporter.incWriteTime(v);
        }
    }

    static class ReadMetrics
    extends ShuffleReadMetrics {
        private ShuffleReadMetricsReporter reporter;

        ReadMetrics(ShuffleReadMetricsReporter reporter) {
            this.reporter = reporter;
        }

        public void incRemoteBytesRead(long v) {
            this.reporter.incRemoteBytesRead(v);
        }

        public void incFetchWaitTime(long v) {
            this.reporter.incFetchWaitTime(v);
        }

        public void incRecordsRead(long v) {
            this.reporter.incRecordsRead(v);
        }
    }
}

