/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.handle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.TaskContext;
import org.apache.spark.shuffle.handle.ShuffleHandleInfoBase;
import org.apache.spark.shuffle.handle.split.PartitionSplitInfo;
import org.apache.uniffle.client.PartitionDataReplicaRequirementTracking;
import org.apache.uniffle.common.PartitionSplitMode;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.org.apache.commons.collections4.CollectionUtils;
import org.apache.uniffle.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.uniffle.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.uniffle.shaded.org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableShuffleHandleInfo
extends ShuffleHandleInfoBase {
    private static final long serialVersionUID = 0L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MutableShuffleHandleInfo.class);
    private Map<Integer, Map<Integer, List<ShuffleServerInfo>>> partitionReplicaAssignedServers;
    private Map<String, Set<ShuffleServerInfo>> excludedServerToReplacements;
    private Map<Integer, Map<String, Set<ShuffleServerInfo>>> excludedServerForPartitionToReplacements;
    private PartitionSplitMode partitionSplitMode = PartitionSplitMode.PIPELINE;

    public MutableShuffleHandleInfo(int shuffleId, Map<Integer, List<ShuffleServerInfo>> partitionToServers, RemoteStorageInfo storageInfo) {
        this(shuffleId, storageInfo, MutableShuffleHandleInfo.toPartitionReplicaMapping(partitionToServers));
    }

    public MutableShuffleHandleInfo(int shuffleId, Map<Integer, List<ShuffleServerInfo>> partitionToServers, RemoteStorageInfo storageInfo, PartitionSplitMode partitionSplitMode) {
        this(shuffleId, storageInfo, MutableShuffleHandleInfo.toPartitionReplicaMapping(partitionToServers));
        this.partitionSplitMode = partitionSplitMode;
    }

    @VisibleForTesting
    protected MutableShuffleHandleInfo(int shuffleId, RemoteStorageInfo storageInfo, Map<Integer, Map<Integer, List<ShuffleServerInfo>>> partitionReplicaAssignedServers) {
        super(shuffleId, storageInfo);
        this.excludedServerToReplacements = new HashMap<String, Set<ShuffleServerInfo>>();
        this.excludedServerForPartitionToReplacements = new HashMap<Integer, Map<String, Set<ShuffleServerInfo>>>();
        this.partitionReplicaAssignedServers = partitionReplicaAssignedServers;
    }

    public MutableShuffleHandleInfo(int shuffleId, RemoteStorageInfo storageInfo) {
        super(shuffleId, storageInfo);
    }

    private static Map<Integer, Map<Integer, List<ShuffleServerInfo>>> toPartitionReplicaMapping(Map<Integer, List<ShuffleServerInfo>> partitionToServers) {
        HashMap<Integer, Map<Integer, List<ShuffleServerInfo>>> partitionReplicaAssignedServers = new HashMap<Integer, Map<Integer, List<ShuffleServerInfo>>>();
        for (Map.Entry<Integer, List<ShuffleServerInfo>> partitionEntry : partitionToServers.entrySet()) {
            int partitionId = partitionEntry.getKey();
            Map replicaMapping = partitionReplicaAssignedServers.computeIfAbsent(partitionId, x -> new HashMap());
            List<ShuffleServerInfo> replicaServers = partitionEntry.getValue();
            for (int i = 0; i < replicaServers.size(); ++i) {
                int replicaIdx = i;
                replicaMapping.computeIfAbsent(replicaIdx, x -> new ArrayList()).add(replicaServers.get(i));
            }
        }
        return partitionReplicaAssignedServers;
    }

    public Set<ShuffleServerInfo> getReplacements(String faultyServerId) {
        return this.excludedServerToReplacements.get(faultyServerId);
    }

    public Set<ShuffleServerInfo> getReplacementsForPartition(int partitionId, String excludedServerId) {
        return this.excludedServerForPartitionToReplacements.getOrDefault(partitionId, Collections.emptyMap()).getOrDefault(excludedServerId, Collections.emptySet());
    }

    public Set<ShuffleServerInfo> updateAssignment(int partitionId, String receivingFailureServerId, Set<ShuffleServerInfo> replacements) {
        if (replacements == null || StringUtils.isEmpty(receivingFailureServerId)) {
            return Collections.emptySet();
        }
        this.excludedServerToReplacements.put(receivingFailureServerId, replacements);
        return this.updateAssignmentInternal(partitionId, receivingFailureServerId, replacements);
    }

    private Set<ShuffleServerInfo> updateAssignmentInternal(int partitionId, String receivingFailureServerId, Set<ShuffleServerInfo> replacements) {
        HashSet<ShuffleServerInfo> updatedServers = new HashSet<ShuffleServerInfo>();
        Map<Integer, List<ShuffleServerInfo>> replicaServers = this.partitionReplicaAssignedServers.get(partitionId);
        for (Map.Entry<Integer, List<ShuffleServerInfo>> serverEntry : replicaServers.entrySet()) {
            List<ShuffleServerInfo> servers = serverEntry.getValue();
            if (!servers.stream().map(x -> x.getId()).collect(Collectors.toSet()).contains(receivingFailureServerId)) continue;
            HashSet<ShuffleServerInfo> tempSet = new HashSet<ShuffleServerInfo>();
            tempSet.addAll(replacements);
            tempSet.removeAll(servers);
            if (!CollectionUtils.isNotEmpty(tempSet)) continue;
            updatedServers.addAll(tempSet);
            servers.addAll(tempSet);
        }
        return updatedServers;
    }

    public Set<ShuffleServerInfo> updateAssignmentOnPartitionSplit(int partitionId, String receivingFailureServerId, Set<ShuffleServerInfo> replacements) {
        if (replacements == null || StringUtils.isEmpty(receivingFailureServerId)) {
            return Collections.emptySet();
        }
        this.excludedServerForPartitionToReplacements.computeIfAbsent(partitionId, x -> new HashMap()).put(receivingFailureServerId, replacements);
        return this.updateAssignmentInternal(partitionId, receivingFailureServerId, replacements);
    }

    @Override
    public Set<ShuffleServerInfo> getServers() {
        return this.partitionReplicaAssignedServers.values().stream().flatMap(x -> x.values().stream().flatMap(k -> k.stream())).collect(Collectors.toSet());
    }

    @Override
    public Map<Integer, List<ShuffleServerInfo>> getAvailablePartitionServersForWriter(Map<Integer, List<ShuffleServerInfo>> exclusiveServers) {
        Map<Object, Object> requestExclusiveServers = exclusiveServers == null ? Collections.emptyMap() : exclusiveServers;
        HashMap<Integer, List<ShuffleServerInfo>> assignment = new HashMap<Integer, List<ShuffleServerInfo>>();
        for (Map.Entry<Integer, Map<Integer, List<ShuffleServerInfo>>> entry : this.partitionReplicaAssignedServers.entrySet()) {
            int partitionId = entry.getKey();
            List partitionExclusiveServers = requestExclusiveServers.getOrDefault(partitionId, Collections.emptyList());
            Map<Integer, List<ShuffleServerInfo>> replicaServers = entry.getValue();
            PartitionSplitInfo splitInfo = this.getPartitionSplitInfo(partitionId);
            for (Map.Entry<Integer, List<ShuffleServerInfo>> replicaServerEntry : replicaServers.entrySet()) {
                List servers;
                int serverSize;
                ShuffleServerInfo candidate = replicaServerEntry.getValue().get(replicaServerEntry.getValue().size() - 1);
                long taskAttemptId = Optional.ofNullable(TaskContext.get()).map(x -> x.taskAttemptId()).orElse(-1L);
                if (taskAttemptId != -1L && splitInfo.isSplit() && splitInfo.getMode() == PartitionSplitMode.LOAD_BALANCE && (serverSize = (servers = replicaServerEntry.getValue().stream().filter(x -> !this.excludedServerToReplacements.containsKey(x.getId())).filter(x -> !partitionExclusiveServers.contains(x)).collect(Collectors.toList())).size()) > 1) {
                    int idx = (int)(taskAttemptId % (long)(serverSize - 1)) + 1;
                    candidate = (ShuffleServerInfo)servers.get(idx);
                }
                assignment.computeIfAbsent(partitionId, x -> new ArrayList()).add(candidate);
            }
        }
        return assignment;
    }

    @Override
    public Map<Integer, List<ShuffleServerInfo>> getAllPartitionServersForReader() {
        HashMap<Integer, List<ShuffleServerInfo>> assignment = new HashMap<Integer, List<ShuffleServerInfo>>();
        for (Map.Entry<Integer, Map<Integer, List<ShuffleServerInfo>>> entry : this.partitionReplicaAssignedServers.entrySet()) {
            int partitionId = entry.getKey();
            Map<Integer, List<ShuffleServerInfo>> replicaServers = entry.getValue();
            for (Map.Entry<Integer, List<ShuffleServerInfo>> replicaServerEntry : replicaServers.entrySet()) {
                assignment.computeIfAbsent(partitionId, x -> new ArrayList()).addAll((Collection)replicaServerEntry.getValue());
            }
        }
        return assignment;
    }

    @Override
    public PartitionDataReplicaRequirementTracking createPartitionReplicaTracking() {
        PartitionDataReplicaRequirementTracking replicaRequirement = new PartitionDataReplicaRequirementTracking(this.shuffleId, this.partitionReplicaAssignedServers);
        return replicaRequirement;
    }

    @Override
    public PartitionSplitInfo getPartitionSplitInfo(int partitionId) {
        boolean isSplit = this.excludedServerForPartitionToReplacements.containsKey(partitionId);
        return new PartitionSplitInfo(partitionId, isSplit, this.partitionSplitMode, new ArrayList<List<ShuffleServerInfo>>(this.partitionReplicaAssignedServers.get(partitionId).values()));
    }

    public Set<String> listExcludedServers() {
        return this.excludedServerToReplacements.keySet();
    }

    public void checkPartitionReassignServerNum(Set<Integer> partitionIds, int legalReassignServerNum) {
        for (int partitionId : partitionIds) {
            if (this.isPartitionSplit(partitionId)) continue;
            Map<Integer, List<ShuffleServerInfo>> replicas = this.partitionReplicaAssignedServers.get(partitionId);
            for (List<ShuffleServerInfo> servers : replicas.values()) {
                if (servers.size() - 1 <= legalReassignServerNum) continue;
                throw new RssException("Illegal reassignment servers for partitionId: " + partitionId + " that exceeding the max legal reassign server num: " + legalReassignServerNum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static RssProtos.MutableShuffleHandleInfo toProto(MutableShuffleHandleInfo handleInfo) {
        MutableShuffleHandleInfo mutableShuffleHandleInfo = handleInfo;
        synchronized (mutableShuffleHandleInfo) {
            void var5_12;
            HashMap<ShuffleServerInfo, List> serverToPartitions = new HashMap<ShuffleServerInfo, List>();
            for (Map.Entry<Integer, Map<Integer, List<ShuffleServerInfo>>> entry : handleInfo.partitionReplicaAssignedServers.entrySet()) {
                int n = entry.getKey();
                Map<Integer, List<ShuffleServerInfo>> replicaServers = entry.getValue();
                for (Map.Entry<Integer, List<ShuffleServerInfo>> replicaServerEntry : replicaServers.entrySet()) {
                    int replicaIndex = replicaServerEntry.getKey();
                    List<ShuffleServerInfo> servers = replicaServerEntry.getValue();
                    for (int i = 0; i < servers.size(); ++i) {
                        ShuffleServerInfo server = servers.get(i);
                        serverToPartitions.computeIfAbsent(server, x -> new ArrayList()).add(Triple.of(n, replicaIndex, i));
                    }
                }
            }
            ArrayList<RssProtos.ServerToPartitionsItem> protoServerToPartitionsItems = new ArrayList<RssProtos.ServerToPartitionsItem>();
            for (Map.Entry entry : serverToPartitions.entrySet()) {
                ArrayList<RssProtos.PartitionReplicaItem> replicaItems = new ArrayList<RssProtos.PartitionReplicaItem>();
                for (Triple partitionReplica : (List)entry.getValue()) {
                    replicaItems.add(RssProtos.PartitionReplicaItem.newBuilder().setPartitionId((Integer)partitionReplica.getLeft()).setReplicaIndex((Integer)partitionReplica.getMiddle()).setSequenceIndex((Integer)partitionReplica.getRight()).build());
                }
                protoServerToPartitionsItems.add(RssProtos.ServerToPartitionsItem.newBuilder().setServerId(ShuffleServerInfo.convertToShuffleServerId((ShuffleServerInfo)entry.getKey())).addAllPartitionToReplicaItems(replicaItems).build());
            }
            HashMap<String, RssProtos.ReplacementServers> hashMap = new HashMap<String, RssProtos.ReplacementServers>();
            for (Map.Entry<String, Set<ShuffleServerInfo>> entry : handleInfo.excludedServerToReplacements.entrySet()) {
                RssProtos.ReplacementServers replacementServers = RssProtos.ReplacementServers.newBuilder().addAllServerId(ShuffleServerInfo.toProto(new ArrayList<ShuffleServerInfo>((Collection)entry.getValue()))).build();
                hashMap.put(entry.getKey(), replacementServers);
            }
            RssProtos.PartitionSplitMode partitionSplitMode = RssProtos.PartitionSplitMode.PIPELINE;
            if (handleInfo.partitionSplitMode == PartitionSplitMode.LOAD_BALANCE) {
                RssProtos.PartitionSplitMode partitionSplitMode2 = RssProtos.PartitionSplitMode.LOAD_BALANCE;
            }
            RssProtos.MutableShuffleHandleInfo handleProto = RssProtos.MutableShuffleHandleInfo.newBuilder().setShuffleId(handleInfo.shuffleId).setRemoteStorageInfo(RssProtos.RemoteStorageInfo.newBuilder().setPath(handleInfo.remoteStorage.getPath()).putAllConfItems(handleInfo.remoteStorage.getConfItems()).build()).putAllExcludedServerToReplacements(hashMap).addAllServerToPartitionItem(protoServerToPartitionsItems).setPartitionSplitMode((RssProtos.PartitionSplitMode)var5_12).addAllSplitPartitionId(handleInfo.excludedServerForPartitionToReplacements.keySet()).build();
            return handleProto;
        }
    }

    public static MutableShuffleHandleInfo fromProto(RssProtos.MutableShuffleHandleInfo handleProto) {
        if (handleProto == null) {
            return null;
        }
        HashMap<Integer, Map> partitionToServers = new HashMap<Integer, Map>();
        for (RssProtos.ServerToPartitionsItem serverToPartitionsItem : handleProto.getServerToPartitionItemList()) {
            ShuffleServerInfo shuffleServerInfo = ShuffleServerInfo.convertFromShuffleServerId(serverToPartitionsItem.getServerId());
            for (RssProtos.PartitionReplicaItem partitionReplicaItem : serverToPartitionsItem.getPartitionToReplicaItemsList()) {
                int partitionId = partitionReplicaItem.getPartitionId();
                int replicaIndex = partitionReplicaItem.getReplicaIndex();
                int sequenceIndex = partitionReplicaItem.getSequenceIndex();
                partitionToServers.computeIfAbsent(partitionId, k -> new HashMap()).computeIfAbsent(replicaIndex, k -> new ArrayList()).add(Pair.of(sequenceIndex, shuffleServerInfo));
            }
        }
        HashMap<Integer, Map<Integer, List<ShuffleServerInfo>>> partitionReplicaAssignedServers = new HashMap<Integer, Map<Integer, List<ShuffleServerInfo>>>();
        for (Map.Entry entry : partitionToServers.entrySet()) {
            int n = (Integer)entry.getKey();
            Map replicaMap = (Map)entry.getValue();
            HashMap replicaAssignedMap = new HashMap();
            for (Map.Entry replicaEntry : replicaMap.entrySet()) {
                int replicaIndex = (Integer)replicaEntry.getKey();
                List pairs = (List)replicaEntry.getValue();
                pairs.sort(Comparator.comparingInt(Pair::getLeft));
                List servers = pairs.stream().map(Pair::getRight).collect(Collectors.toList());
                replicaAssignedMap.put(replicaIndex, servers);
            }
            partitionReplicaAssignedServers.put(n, replicaAssignedMap);
        }
        HashMap<String, Set<ShuffleServerInfo>> hashMap = new HashMap<String, Set<ShuffleServerInfo>>();
        for (Map.Entry<String, RssProtos.ReplacementServers> entry : handleProto.getExcludedServerToReplacementsMap().entrySet()) {
            hashMap.put(entry.getKey(), new HashSet<ShuffleServerInfo>(ShuffleServerInfo.fromProto(entry.getValue().getServerIdList())));
        }
        HashMap<Integer, Map<String, Set<ShuffleServerInfo>>> hashMap2 = new HashMap<Integer, Map<String, Set<ShuffleServerInfo>>>();
        for (int partitionId : handleProto.getSplitPartitionIdList()) {
            hashMap2.computeIfAbsent(partitionId, x -> new HashMap());
        }
        RemoteStorageInfo remoteStorageInfo = new RemoteStorageInfo(handleProto.getRemoteStorageInfo().getPath(), handleProto.getRemoteStorageInfo().getConfItemsMap());
        MutableShuffleHandleInfo handle = new MutableShuffleHandleInfo(handleProto.getShuffleId(), remoteStorageInfo);
        handle.partitionReplicaAssignedServers = partitionReplicaAssignedServers;
        handle.partitionSplitMode = handleProto.getPartitionSplitMode() == RssProtos.PartitionSplitMode.LOAD_BALANCE ? PartitionSplitMode.LOAD_BALANCE : PartitionSplitMode.PIPELINE;
        handle.excludedServerForPartitionToReplacements = hashMap2;
        handle.excludedServerToReplacements = hashMap;
        return handle;
    }

    public Set<String> listExcludedServersForPartition(int partitionId) {
        return this.excludedServerForPartitionToReplacements.getOrDefault(partitionId, Collections.emptyMap()).keySet();
    }

    public boolean isPartitionSplit(int partitionId) {
        return this.excludedServerForPartitionToReplacements.containsKey(partitionId);
    }
}

