/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import org.apache.uniffle.common.netty.DecodeException;
import org.apache.uniffle.common.netty.EncodeException;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RequestMessage;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;

public class GetSortedShuffleDataRequest
extends RequestMessage {
    private final String appId;
    private final int shuffleId;
    private final int partitionId;
    private final long blockId;
    private final int length;
    private final long timestamp;

    public GetSortedShuffleDataRequest(long requestId, String appId, int shuffleId, int partitionId, long blockId, int length, long timestamp) {
        super(requestId);
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionId = partitionId;
        this.blockId = blockId;
        this.length = length;
        this.timestamp = timestamp;
    }

    @Override
    public String getOperationType() {
        return "getSortedShuffleData";
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_SORTED_SHUFFLE_DATA_REQUEST;
    }

    @Override
    public int encodedLength() {
        return 8 + ByteBufUtils.encodedLength(this.appId) + 12 + 16;
    }

    @Override
    public void encode(ByteBuf buf) throws EncodeException {
        buf.writeLong(this.getRequestId());
        ByteBufUtils.writeLengthAndString(buf, this.appId);
        buf.writeInt(this.shuffleId);
        buf.writeInt(this.partitionId);
        buf.writeLong(this.blockId);
        buf.writeInt(this.length);
        buf.writeLong(this.timestamp);
    }

    public static GetSortedShuffleDataRequest decode(ByteBuf buf) throws DecodeException {
        long requestId = buf.readLong();
        String appId = ByteBufUtils.readLengthAndString(buf);
        int shuffleId = buf.readInt();
        int partitionId = buf.readInt();
        long blockId = buf.readLong();
        int length = buf.readInt();
        long timestamp = buf.readLong();
        return new GetSortedShuffleDataRequest(requestId, appId, shuffleId, partitionId, blockId, length, timestamp);
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public int getLength() {
        return this.length;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

