/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.UnsafeInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.uniffle.common.serializer.DeserializationStream;
import org.apache.uniffle.common.serializer.SerInputStream;
import org.apache.uniffle.common.serializer.kryo.KryoSerializerInstance;

public class KryoDeserializationStream<K, V>
extends DeserializationStream<K, V> {
    private SerInputStream inputStream;
    private Input input;
    private final KryoSerializerInstance instance;
    private Kryo kryo;
    private long start;
    private K currentKey;
    private V currentValue;

    public KryoDeserializationStream(KryoSerializerInstance instance, SerInputStream inputStream, Class<K> keyClass, Class<V> valueClass) {
        this.inputStream = inputStream;
        this.instance = instance;
        this.start = inputStream.getStart();
    }

    @Override
    public void init() {
        this.inputStream.init();
        this.input = new UnsafeInput((InputStream)this.inputStream);
        this.kryo = this.instance.borrowKryo();
    }

    @Override
    public boolean nextRecord() throws IOException {
        boolean hasNext;
        boolean bl = hasNext = this.available() > 0L;
        if (hasNext) {
            try {
                this.currentKey = this.kryo.readClassAndObject(this.input);
                this.currentValue = this.kryo.readClassAndObject(this.input);
            }
            catch (KryoException e) {
                if (e.getMessage().toLowerCase(Locale.ROOT).contains("buffer underflow")) {
                    throw new EOFException();
                }
                throw e;
            }
        }
        return hasNext;
    }

    @Override
    public K getCurrentKey() throws IOException {
        return this.currentKey;
    }

    @Override
    public V getCurrentValue() throws IOException {
        return this.currentValue;
    }

    private long available() throws IOException {
        long totalBytesRead = this.start + this.input.total();
        return this.inputStream.getEnd() - totalBytesRead;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.input != null) {
            try {
                this.input.close();
            }
            finally {
                this.instance.releaseKryo(this.kryo);
                this.kryo = null;
                this.input = null;
            }
        }
    }
}

