/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.web.resource;

public class Response<T> {
    private static final int SUCCESS_CODE = 0;
    private static final int ERROR_CODE = -1;
    private int code;
    private T data;
    private String msg;

    public Response() {
    }

    public Response(int code, T data, String msg) {
        this.code = code;
        this.data = data;
        this.msg = msg;
    }

    public static <T> Response<T> success(T data) {
        return new Response<T>(0, data, "success");
    }

    public static <T> Response<T> fail(String msg) {
        return new Response<Object>(-1, null, msg);
    }

    public static <T> Response<T> fail(String msg, int code) {
        return new Response<Object>(code, null, msg);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getErrMsg() {
        return this.msg;
    }

    public void setErrMsg(String errMsg) {
        this.msg = errMsg;
    }
}

