/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shuffle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.uniffle.client.PartitionDataReplicaRequirementTracking;
import org.apache.uniffle.client.api.ShuffleManagerClient;
import org.apache.uniffle.client.impl.ShuffleWriteClientImpl;
import org.apache.uniffle.client.request.RssGetShuffleResultForMultiPartRequest;
import org.apache.uniffle.client.request.RssGetShuffleResultRequest;
import org.apache.uniffle.client.request.RssReportShuffleResultRequest;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.BlockIdLayout;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.apache.uniffle.shuffle.RssShuffleClientFactory;

public class BlockIdSelfManagedShuffleWriteClient
extends ShuffleWriteClientImpl {
    private Supplier<ShuffleManagerClient> managerClientSupplier;

    public BlockIdSelfManagedShuffleWriteClient(RssShuffleClientFactory.ExtendWriteClientBuilder builder) {
        super(builder);
        if (builder.getManagerClientSupplier() == null) {
            throw new RssException("Illegal empty shuffleManagerClient. This should not happen");
        }
        this.managerClientSupplier = builder.getManagerClientSupplier();
    }

    @Override
    public void reportShuffleResult(Map<ShuffleServerInfo, Map<Integer, Set<Long>>> serverToPartitionToBlockIds, String appId, int shuffleId, long taskAttemptId, int bitmapNum) {
        HashMap<Integer, List<Long>> partitionToBlockIds = new HashMap<Integer, List<Long>>();
        for (Map<Integer, Set<Long>> k : serverToPartitionToBlockIds.values()) {
            for (Map.Entry<Integer, Set<Long>> entry : k.entrySet()) {
                int partitionId = entry.getKey();
                partitionToBlockIds.computeIfAbsent(partitionId, x -> new ArrayList()).addAll((Collection)entry.getValue());
            }
        }
        RssReportShuffleResultRequest request = new RssReportShuffleResultRequest(appId, shuffleId, taskAttemptId, partitionToBlockIds, bitmapNum);
        this.managerClientSupplier.get().reportShuffleResult(request);
    }

    @Override
    public void reportShuffleResult(Map<ShuffleServerInfo, Map<Integer, Set<Long>>> serverToPartitionToBlockIds, String appId, int shuffleId, long taskAttemptId, int bitmapNum, Set<ShuffleServerInfo> reportFailureServers, boolean enableWriteFailureRetry) {
        HashMap<Integer, List<Long>> partitionToBlockIds = new HashMap<Integer, List<Long>>();
        for (Map<Integer, Set<Long>> k : serverToPartitionToBlockIds.values()) {
            for (Map.Entry<Integer, Set<Long>> entry : k.entrySet()) {
                int partitionId = entry.getKey();
                partitionToBlockIds.computeIfAbsent(partitionId, x -> new ArrayList()).addAll((Collection)entry.getValue());
            }
        }
        RssReportShuffleResultRequest request = new RssReportShuffleResultRequest(appId, shuffleId, taskAttemptId, partitionToBlockIds, bitmapNum);
        this.managerClientSupplier.get().reportShuffleResult(request);
    }

    @Override
    public Roaring64NavigableMap getShuffleResult(String clientType, Set<ShuffleServerInfo> shuffleServerInfoSet, String appId, int shuffleId, int partitionId) {
        RssGetShuffleResultRequest request = new RssGetShuffleResultRequest(appId, shuffleId, partitionId, BlockIdLayout.DEFAULT);
        return this.managerClientSupplier.get().getShuffleResult(request).getBlockIdBitmap();
    }

    @Override
    public Roaring64NavigableMap getShuffleResultForMultiPart(String clientType, Map<ShuffleServerInfo, Set<Integer>> serverToPartitions, String appId, int shuffleId, Set<Integer> failedPartitions, PartitionDataReplicaRequirementTracking replicaRequirementTracking) {
        Set<Integer> partitionIds = serverToPartitions.values().stream().flatMap(x -> x.stream()).collect(Collectors.toSet());
        RssGetShuffleResultForMultiPartRequest request = new RssGetShuffleResultForMultiPartRequest(appId, shuffleId, partitionIds, BlockIdLayout.DEFAULT);
        return this.managerClientSupplier.get().getShuffleResultForMultiPart(request).getBlockIdBitmap();
    }
}

