/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.storage;

import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.proto.RssProtos;

public enum StorageMedia {
    UNKNOWN(0),
    HDD(1),
    SSD(2),
    HDFS(3),
    OBJECT_STORE(4);

    private final byte val;

    private StorageMedia(int code) {
        if (code < -1 || code >= 256) {
            throw new RssException("The code should be within [-1, 256)");
        }
        this.val = (byte)code;
    }

    public RssProtos.StorageInfo.StorageMedia toProto() {
        switch (this) {
            case UNKNOWN: {
                return RssProtos.StorageInfo.StorageMedia.STORAGE_TYPE_UNKNOWN;
            }
            case HDD: {
                return RssProtos.StorageInfo.StorageMedia.HDD;
            }
            case SSD: {
                return RssProtos.StorageInfo.StorageMedia.SSD;
            }
            case HDFS: {
                return RssProtos.StorageInfo.StorageMedia.HDFS;
            }
            case OBJECT_STORE: {
                return RssProtos.StorageInfo.StorageMedia.OBJECT_STORE;
            }
        }
        return RssProtos.StorageInfo.StorageMedia.UNRECOGNIZED;
    }

    public static StorageMedia fromProto(RssProtos.StorageInfo.StorageMedia storageMedia) {
        switch (storageMedia) {
            case HDD: {
                return HDD;
            }
            case SSD: {
                return SSD;
            }
            case HDFS: {
                return HDFS;
            }
            case OBJECT_STORE: {
                return OBJECT_STORE;
            }
        }
        return UNKNOWN;
    }
}

