/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.util.List;
import java.util.Map;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.handle.SimpleShuffleHandleInfo;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleServerInfo;

public class RssShuffleHandle<K, V, C>
extends ShuffleHandle {
    private static final long serialVersionUID = 0L;
    private String appId;
    private int numMaps;
    private ShuffleDependency<K, V, C> dependency;
    private Broadcast<SimpleShuffleHandleInfo> handlerInfoBd;

    public RssShuffleHandle(int shuffleId, String appId, int numMaps, ShuffleDependency<K, V, C> dependency, Broadcast<SimpleShuffleHandleInfo> handlerInfoBd) {
        super(shuffleId);
        this.appId = appId;
        this.numMaps = numMaps;
        this.dependency = dependency;
        this.handlerInfoBd = handlerInfoBd;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getNumMaps() {
        return this.numMaps;
    }

    public ShuffleDependency<K, V, C> getDependency() {
        return this.dependency;
    }

    public int getShuffleId() {
        return this.shuffleId();
    }

    public RemoteStorageInfo getRemoteStorage() {
        return ((SimpleShuffleHandleInfo)this.handlerInfoBd.value()).getRemoteStorage();
    }

    public Map<Integer, List<ShuffleServerInfo>> getPartitionToServers() {
        return ((SimpleShuffleHandleInfo)this.handlerInfoBd.value()).getAvailablePartitionServersForWriter();
    }
}

