/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.uniffle.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.uniffle.shaded.org.apache.commons.lang3.time.DateFormatUtils;

public class Application
implements Comparable<Application> {
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private String applicationId;
    private String user;
    private String lastHeartBeatTime;
    private String remoteStoragePath;
    private String registrationTime;

    public Application() {
    }

    public Application(Builder builder) {
        this.applicationId = builder.applicationId;
        this.user = builder.user;
        this.lastHeartBeatTime = builder.lastHeartBeatTime;
        this.remoteStoragePath = builder.remoteStoragePath;
        this.registrationTime = builder.registrationTime;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getUser() {
        return this.user;
    }

    public String getLastHeartBeatTime() {
        return this.lastHeartBeatTime;
    }

    public String getRegistrationTime() {
        return this.registrationTime;
    }

    public String getRemoteStoragePath() {
        return this.remoteStoragePath;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setLastHeartBeatTime(String lastHeartBeatTime) {
        this.lastHeartBeatTime = lastHeartBeatTime;
    }

    public void setRegistrationTime(String registrationTime) {
        this.registrationTime = registrationTime;
    }

    public void setRemoteStoragePath(String remoteStoragePath) {
        this.remoteStoragePath = remoteStoragePath;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Application)) {
            return false;
        }
        Application otherImpl = (Application)this.getClass().cast(other);
        return new EqualsBuilder().append(this.getApplicationId(), otherImpl.getApplicationId()).append(this.getUser(), otherImpl.getUser()).append(this.getLastHeartBeatTime(), otherImpl.getLastHeartBeatTime()).append(this.getRegistrationTime(), otherImpl.getRegistrationTime()).append(this.getRemoteStoragePath(), otherImpl.getRemoteStoragePath()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getApplicationId()).append(this.getUser()).append(this.getLastHeartBeatTime()).append(this.getRegistrationTime()).append(this.getRemoteStoragePath()).toHashCode();
    }

    @Override
    public int compareTo(Application other) {
        return this.applicationId.compareTo(other.applicationId);
    }

    public String toString() {
        return "Application{applicationId='" + this.applicationId + '\'' + ", user='" + this.user + '\'' + ", lastHeartBeatTime='" + this.lastHeartBeatTime + '\'' + ", registrationTime='" + this.registrationTime + '\'' + ", remoteStoragePath='" + this.remoteStoragePath + '\'' + '}';
    }

    public static class Builder {
        private String applicationId;
        private String user;
        private String lastHeartBeatTime;
        private String registrationTime;
        private String remoteStoragePath;

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder lastHeartBeatTime(long lastHeartBeatTime) {
            this.lastHeartBeatTime = DateFormatUtils.format(lastHeartBeatTime, Application.DATE_PATTERN);
            return this;
        }

        public Builder registrationTime(long registrationTime) {
            this.registrationTime = DateFormatUtils.format(registrationTime, Application.DATE_PATTERN);
            return this;
        }

        public Builder remoteStoragePath(RemoteStorageInfo remoteStorageInfo) {
            if (remoteStorageInfo != null) {
                this.remoteStoragePath = remoteStorageInfo.getPath();
            }
            return this;
        }

        public Application build() {
            return new Application(this);
        }
    }
}

