/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.uniffle.common.serializer.SerOutputStream;

public class FileSerOutputStream
extends SerOutputStream {
    private OutputStream outputStream;

    public FileSerOutputStream(File file) throws IOException {
        this.outputStream = new FileOutputStream(file);
    }

    @Override
    public void write(ByteBuf from) throws IOException {
        byte[] bytes = new byte[from.readableBytes()];
        from.readBytes(bytes);
        this.outputStream.write(bytes);
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
    }
}

