/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.uniffle.common.util.StatefulCloseable;
import org.apache.uniffle.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiringCloseableSupplier<T extends StatefulCloseable>
implements Supplier<T>,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(ExpiringCloseableSupplier.class);
    private static final int DEFAULT_DELAY_CLOSE_INTERVAL = 60000;
    private static final ScheduledExecutorService executor = ThreadUtils.getDaemonSingleThreadScheduledExecutor("ExpiringCloseableSupplier");
    private final Supplier<T> delegate;
    private final long delayCloseInterval;
    private volatile transient ScheduledFuture<?> future;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private volatile transient long accessTime = System.currentTimeMillis();
    private volatile transient T t;

    private ExpiringCloseableSupplier(Supplier<T> delegate, long delayCloseInterval) {
        this.delegate = delegate;
        this.delayCloseInterval = delayCloseInterval;
    }

    @Override
    public synchronized T get() {
        this.accessTime = System.currentTimeMillis();
        if (this.t == null || this.t.isClosed()) {
            this.t = (StatefulCloseable)this.delegate.get();
            this.ensureCloseFutureScheduled();
        }
        return this.t;
    }

    public synchronized void close() {
        try {
            if (this.t != null && !this.t.isClosed()) {
                this.t.close();
            }
        }
        catch (IOException ioe) {
            LOG.warn("Failed to close {} the resource", (Object)this.t.getClass().getName(), (Object)ioe);
        }
        finally {
            this.t = null;
            this.accessTime = System.currentTimeMillis();
            this.cancelCloseFuture();
        }
    }

    private void tryClose() {
        if (System.currentTimeMillis() - this.accessTime > this.delayCloseInterval) {
            this.close();
        }
    }

    private void ensureCloseFutureScheduled() {
        this.cancelCloseFuture();
        this.future = executor.scheduleAtFixedRate(this::tryClose, this.delayCloseInterval, this.delayCloseInterval, TimeUnit.MILLISECONDS);
    }

    private void cancelCloseFuture() {
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    public static <T extends StatefulCloseable> ExpiringCloseableSupplier<T> of(Supplier<T> delegate) {
        return new ExpiringCloseableSupplier<T>(delegate, 60000L);
    }

    public static <T extends StatefulCloseable> ExpiringCloseableSupplier<T> of(Supplier<T> delegate, long delayCloseInterval) {
        return new ExpiringCloseableSupplier<T>(delegate, delayCloseInterval);
    }
}

