/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.dashboard.web.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.uniffle.common.util.Constants;
import org.apache.uniffle.common.web.resource.BaseResource;
import org.apache.uniffle.common.web.resource.Response;
import org.apache.uniffle.dashboard.web.Dashboard;
import org.apache.uniffle.dashboard.web.config.DashboardConf;
import org.apache.uniffle.dashboard.web.vo.DashboardConfVO;

@Produces(value={"application/json"})
public class DashboardResource
extends BaseResource {
    @Context
    protected ServletContext servletContext;

    @GET
    @Path(value="/conf")
    public Response<List<DashboardConfVO>> getDashboardConf() {
        return this.execute(() -> {
            DashboardConf conf = this.getDashboard().getConf();
            Set allEntry = conf.getAll();
            ArrayList<DashboardConfVO> dashboardConfVOs = new ArrayList<DashboardConfVO>();
            for (Map.Entry stringObjectEntry : allEntry) {
                DashboardConfVO result = new DashboardConfVO((String)stringObjectEntry.getKey(), String.valueOf(stringObjectEntry.getValue()));
                dashboardConfVOs.add(result);
            }
            return dashboardConfVOs;
        });
    }

    @GET
    @Path(value="/info")
    public Response<Map<String, Object>> getDashboardInfo() {
        return this.execute(() -> {
            HashMap<String, Object> dashboardInfo = new HashMap<String, Object>();
            dashboardInfo.put("version", Constants.VERSION_AND_REVISION_SHORT);
            dashboardInfo.put("startTime", this.getDashboard().getStartTimeMs());
            return dashboardInfo;
        });
    }

    private Dashboard getDashboard() {
        return (Dashboard)this.servletContext.getAttribute(Dashboard.class.getCanonicalName());
    }
}

