/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputCollector;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.SortWriteBufferManager;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapreduce.RssMRConfig;
import org.apache.hadoop.mapreduce.RssMRUtils;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.ByteUnit;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.com.google.common.collect.Maps;
import org.apache.uniffle.shaded.com.google.common.collect.Sets;
import org.apache.uniffle.storage.util.StorageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssMapOutputCollector<K, V>
implements MapOutputCollector<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(RssMapOutputCollector.class);
    private Task.TaskReporter reporter;
    private Class<K> keyClass;
    private Class<V> valClass;
    private Set<Long> successBlockIds = Sets.newConcurrentHashSet();
    private Set<Long> failedBlockIds = Sets.newConcurrentHashSet();
    private int partitions;
    private SortWriteBufferManager bufferManager;
    private ShuffleWriteClient shuffleClient;
    private Task.CombinerRunner<K, V> combinerRunner;

    public void init(MapOutputCollector.Context context) throws IOException, ClassNotFoundException {
        JobConf mrJobConf = context.getJobConf();
        this.reporter = context.getReporter();
        this.keyClass = mrJobConf.getMapOutputKeyClass();
        this.valClass = mrJobConf.getMapOutputValueClass();
        int sortmb = mrJobConf.getInt("mapreduce.task.io.sort.mb", 100);
        if ((sortmb & 0x7FF) != sortmb) {
            throw new IOException("Invalid \"mapreduce.task.io.sort.mb\": " + sortmb);
        }
        this.partitions = mrJobConf.getNumReduceTasks();
        MapTask mapTask = context.getMapTask();
        JobConf rssJobConf = new JobConf("rss_conf.xml");
        double sortThreshold = RssMRUtils.getDouble((Configuration)rssJobConf, "mapreduce.rss.client.sort.memory.use.threshold", 0.9f);
        if (sortThreshold <= 0.0 || Double.compare(sortThreshold, 1.0) > 0) {
            throw new IOException("Invalid  sort memory use threshold : " + sortThreshold);
        }
        boolean enableCombiner = RssMRUtils.getBoolean((Configuration)rssJobConf, "mapreduce.rss.client.combiner.enable", false);
        this.combinerRunner = null;
        if (enableCombiner) {
            try {
                Counters.Counter combineInputCounter = this.reporter.getCounter((Enum)TaskCounter.COMBINE_INPUT_RECORDS);
                this.combinerRunner = Task.CombinerRunner.create((JobConf)mrJobConf, (org.apache.hadoop.mapred.TaskAttemptID)mapTask.getTaskID(), (Counters.Counter)combineInputCounter, (Task.TaskReporter)this.reporter, null);
                if (this.combinerRunner != null) {
                    LOG.info("Map-stage combiner enabled. Warning: This may cause GC issues in large jobs. Consider setting {}=false if experiencing instability", (Object)"mapreduce.rss.client.combiner.enable");
                }
            }
            catch (Exception e) {
                LOG.error("Get CombinerClass failed", (Throwable)e);
            }
        }
        int batch = RssMRUtils.getInt((Configuration)rssJobConf, "mapreduce.rss.client.batch.trigger.num", 50);
        RawComparator comparator = mrJobConf.getOutputKeyComparator();
        double memoryThreshold = RssMRUtils.getDouble((Configuration)rssJobConf, "mapreduce.rss.client.memory.threshold", 0.8f);
        ApplicationAttemptId applicationAttemptId = RssMRUtils.getApplicationAttemptId();
        String appId = applicationAttemptId.toString();
        long taskAttemptId = RssMRUtils.createRssTaskAttemptId((TaskAttemptID)mapTask.getTaskID(), applicationAttemptId.getAttemptId(), (Configuration)mrJobConf);
        double sendThreshold = RssMRUtils.getDouble((Configuration)rssJobConf, "mapreduce.rss.client.send.threshold", 0.2f);
        long sendCheckInterval = RssMRUtils.getLong((Configuration)rssJobConf, "mapreduce.rss.client.send.check.interval.ms", 500L);
        long sendCheckTimeout = RssMRUtils.getLong((Configuration)rssJobConf, "mapreduce.rss.client.send.check.timeout.ms", 600000L);
        int bitmapSplitNum = RssMRUtils.getInt((Configuration)rssJobConf, "mapreduce.rss.client.bitmap.num", 1);
        int numMaps = mrJobConf.getNumMapTasks();
        String storageType = RssMRUtils.getString((Configuration)rssJobConf, "mapreduce.rss.storage.type");
        if (StringUtils.isEmpty((CharSequence)storageType)) {
            throw new RssException("storage type mustn't be empty");
        }
        Map<Integer, List<ShuffleServerInfo>> partitionToServers = this.createAssignmentMap((Configuration)rssJobConf);
        long maxSegmentSize = RssMRUtils.getLong((Configuration)rssJobConf, "mapreduce.rss.client.max.buffer.size", 3072L);
        int sendThreadNum = RssMRUtils.getInt((Configuration)rssJobConf, "mapreduce.rss.client.send.thread.num", 5);
        long maxBufferSize = RssMRUtils.getLong((Configuration)rssJobConf, "mapreduce.rss.writer.buffer.size", 0xE00000L);
        this.shuffleClient = RssMRUtils.createShuffleClient(mrJobConf);
        boolean isRemoteMergeEnable = RssMRUtils.getBoolean((Configuration)rssJobConf, "mapreduce.rss.remote.merge.enable", false);
        this.bufferManager = new SortWriteBufferManager<K, V>((long)(ByteUnit.MiB.toBytes(sortmb) * sortThreshold), taskAttemptId, batch, this.keyClass, this.valClass, mrJobConf, comparator, memoryThreshold, appId, this.shuffleClient, sendCheckInterval, sendCheckTimeout, partitionToServers, this.successBlockIds, this.failedBlockIds, this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_BYTES), this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS), bitmapSplitNum, maxSegmentSize, numMaps, this.isMemoryShuffleEnabled(storageType), sendThreadNum, sendThreshold, maxBufferSize, RssMRConfig.toRssConf((Configuration)rssJobConf), this.combinerRunner, isRemoteMergeEnable);
    }

    private Map<Integer, List<ShuffleServerInfo>> createAssignmentMap(Configuration jobConf) {
        HashMap<Integer, List<ShuffleServerInfo>> partitionToServers = Maps.newHashMap();
        for (int i = 0; i < this.partitions; ++i) {
            String servers = jobConf.get("mapreduce.rss.assignment.partition." + i);
            if (StringUtils.isEmpty((CharSequence)servers)) {
                throw new RssException("assign partition " + i + " shouldn't be empty");
            }
            String[] splitServers = servers.split(",");
            ArrayList<ShuffleServerInfo> assignServers = Lists.newArrayList();
            RssMRUtils.buildAssignServers(i, splitServers, assignServers);
            partitionToServers.put(i, assignServers);
        }
        return partitionToServers;
    }

    public void collect(K key, V value, int partition) throws IOException, InterruptedException {
        this.reporter.progress();
        if (key.getClass() != this.keyClass) {
            throw new IOException("Type mismatch in key from map: expected " + this.keyClass.getName() + ", received " + key.getClass().getName());
        }
        if (value.getClass() != this.valClass) {
            throw new IOException("Type mismatch in value from map: expected " + this.valClass.getName() + ", received " + value.getClass().getName());
        }
        if (partition < 0 || partition >= this.partitions) {
            throw new IOException("Illegal partition for " + key + " (" + partition + ")");
        }
        this.checkRssException();
        this.bufferManager.addRecord(partition, key, value);
    }

    private void checkRssException() {
        if (!this.failedBlockIds.isEmpty()) {
            throw new RssException("There are some blocks failed");
        }
    }

    public void close() throws IOException, InterruptedException {
        this.reporter.progress();
        this.bufferManager.freeAllResources();
        this.shuffleClient.close();
    }

    public void flush() throws IOException, InterruptedException, ClassNotFoundException {
        this.reporter.progress();
        this.bufferManager.waitSendFinished();
    }

    private boolean isMemoryShuffleEnabled(String storageType) {
        return StorageType.withMemory(StorageType.valueOf(storageType));
    }
}

