/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.request;

import java.util.Collections;
import java.util.List;
import org.apache.uniffle.client.request.RetryableRequest;
import org.apache.uniffle.common.ShuffleDataSegment;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;

public class RssGetShuffleDataRequest
extends RetryableRequest {
    private final String appId;
    private final int shuffleId;
    private final int partitionId;
    private final int partitionNumPerRange;
    private final int partitionNum;
    private final long offset;
    private final int length;
    private final int storageId;
    private final long taskAttemptId;
    private final List<ShuffleDataSegment> nextReadSegments;
    private final boolean nextReadSegmentsReportEnabled;

    public RssGetShuffleDataRequest(String appId, int shuffleId, int partitionId, int partitionNumPerRange, int partitionNum, long offset, int length, int storageId, int retryMax, long retryIntervalMax, long taskAttemptId, List<ShuffleDataSegment> nextReadSegments, boolean nextReadSegmentsReportEnabled) {
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionId = partitionId;
        this.partitionNumPerRange = partitionNumPerRange;
        this.partitionNum = partitionNum;
        this.offset = offset;
        this.length = length;
        this.storageId = storageId;
        this.retryMax = retryMax;
        this.retryIntervalMax = retryIntervalMax;
        this.nextReadSegments = nextReadSegments;
        this.nextReadSegmentsReportEnabled = nextReadSegmentsReportEnabled;
        this.taskAttemptId = taskAttemptId;
    }

    @VisibleForTesting
    public RssGetShuffleDataRequest(String appId, int shuffleId, int partitionId, int partitionNumPerRange, int partitionNum, long offset, int length) {
        this(appId, shuffleId, partitionId, partitionNumPerRange, partitionNum, offset, length, -1, 1, 0L, 0L, Collections.emptyList(), false);
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public int getPartitionNumPerRange() {
        return this.partitionNumPerRange;
    }

    public int getPartitionNum() {
        return this.partitionNum;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getStorageId() {
        return this.storageId;
    }

    public boolean storageIdSpecified() {
        return this.storageId != -1;
    }

    public List<ShuffleDataSegment> getNextReadSegments() {
        return this.nextReadSegments;
    }

    public boolean isNextReadSegmentsReportEnabled() {
        return this.nextReadSegmentsReportEnabled;
    }

    public long getTaskAttemptId() {
        return this.taskAttemptId;
    }

    @Override
    public String operationType() {
        return "GetShuffleData";
    }
}

