/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.merger;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.util.PriorityQueue;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.merger.KeyValueIterator;
import org.apache.uniffle.common.merger.Segment;
import org.apache.uniffle.common.records.RecordsWriter;
import org.apache.uniffle.common.serializer.SerOutputStream;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;

public class Merger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(RssConf conf, SerOutputStream output, List<Segment> segments, Class keyClass, Class valueClass, Comparator comparator, boolean raw) throws IOException {
        try (MergeQueue mergeQueue = new MergeQueue(conf, segments, keyClass, valueClass, comparator, raw, true);){
            mergeQueue.init();
            mergeQueue.merge(output);
        }
    }

    public static class MergeQueue<K, V>
    extends PriorityQueue<Segment>
    implements KeyValueIterator {
        private final RssConf rssConf;
        private final List<Segment> segments;
        private final Class<K> keyClass;
        private final Class<V> valueClass;
        private Comparator comparator;
        private boolean raw;
        private boolean buffered;
        private Object currentKey;
        private Object currentValue;
        private Segment minSegment;
        private Function<Integer, Segment> popSegmentHook;

        public MergeQueue(RssConf rssConf, List<Segment> segments, Class<K> keyClass, Class<V> valueClass, Comparator<K> comparator, boolean raw, boolean buffered) {
            this.rssConf = rssConf;
            this.segments = segments;
            this.keyClass = keyClass;
            this.valueClass = valueClass;
            if (comparator == null) {
                throw new RssException("comparator is null!");
            }
            this.comparator = comparator;
            this.raw = raw;
            this.buffered = buffered;
        }

        public void setPopSegmentHook(Function<Integer, Segment> popSegmentHook) {
            this.popSegmentHook = popSegmentHook;
        }

        protected boolean lessThan(Object o1, Object o2) {
            Object key2;
            if (this.raw) {
                if (this.buffered) {
                    Segment s1 = (Segment)o1;
                    Segment s2 = (Segment)o2;
                    ByteBuf key1 = (ByteBuf)s1.getCurrentKey();
                    ByteBuf key22 = (ByteBuf)s2.getCurrentKey();
                    int c = ((RawComparator)this.comparator).compare(key1.array(), key1.arrayOffset() + key1.readerIndex(), key1.readableBytes(), key22.array(), key22.arrayOffset() + key22.readerIndex(), key22.readableBytes());
                    return c < 0 || c == 0 && s1.getId() < s2.getId();
                }
                Segment s1 = (Segment)o1;
                Segment s2 = (Segment)o2;
                DataOutputBuffer key1 = (DataOutputBuffer)s1.getCurrentKey();
                DataOutputBuffer key23 = (DataOutputBuffer)s2.getCurrentKey();
                int c = ((RawComparator)this.comparator).compare(key1.getData(), 0, key1.getLength(), key23.getData(), 0, key23.getLength());
                return c < 0 || c == 0 && s1.getId() < s2.getId();
            }
            Segment s1 = (Segment)o1;
            Segment s2 = (Segment)o2;
            Object key1 = s1.getCurrentKey();
            int c = this.comparator.compare(key1, key2 = s2.getCurrentKey());
            return c < 0 || c == 0 && s1.getId() < s2.getId();
        }

        public void init() throws IOException {
            ArrayList<Segment> segmentsToMerge = new ArrayList<Segment>();
            for (Segment segment : this.segments) {
                boolean hasNext = segment.next();
                if (hasNext) {
                    segmentsToMerge.add(segment);
                    continue;
                }
                segment.close();
            }
            this.initialize(segmentsToMerge.size());
            this.clear();
            for (Segment segment : segmentsToMerge) {
                this.put(segment);
            }
        }

        public Object getCurrentKey() {
            return this.currentKey;
        }

        public Object getCurrentValue() {
            return this.currentValue;
        }

        @Override
        public boolean next() throws IOException {
            if (this.size() == 0) {
                this.resetKeyValue();
                return false;
            }
            if (this.minSegment != null) {
                this.adjustPriorityQueue(this.minSegment);
                if (this.size() == 0) {
                    this.minSegment = null;
                    this.resetKeyValue();
                    return false;
                }
            }
            this.minSegment = (Segment)this.top();
            this.currentKey = this.minSegment.getCurrentKey();
            this.currentValue = this.minSegment.getCurrentValue();
            return true;
        }

        private void resetKeyValue() {
            this.currentKey = null;
            this.currentValue = null;
        }

        private void adjustPriorityQueue(Segment segment) throws IOException {
            if (segment.next()) {
                this.adjustTop();
            } else {
                Segment newSegment;
                this.pop();
                segment.close();
                if (this.popSegmentHook != null && (newSegment = this.popSegmentHook.apply((int)segment.getId())) != null) {
                    newSegment.init();
                    if (newSegment.next()) {
                        this.put(newSegment);
                    } else {
                        newSegment.close();
                    }
                }
            }
        }

        public void merge(SerOutputStream output) throws IOException {
            try (RecordsWriter writer = new RecordsWriter(this.rssConf, output, this.keyClass, this.valueClass, this.raw, this.buffered);){
                writer.init();
                while (this.next()) {
                    writer.append(this.getCurrentKey(), this.getCurrentValue());
                }
                writer.flush();
            }
        }

        @Override
        public void close() throws IOException {
        }
    }
}

