/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.rpc.GrpcServer;
import org.apache.uniffle.common.rpc.ServerInterface;
import org.apache.uniffle.common.rpc.ServerType;
import org.apache.uniffle.server.ShuffleServer;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerGrpcService;
import org.apache.uniffle.server.ShuffleServerInternalGrpcService;

public class ShuffleServerFactory {
    private final ShuffleServer shuffleServer;
    private final ShuffleServerConf conf;

    public ShuffleServerFactory(ShuffleServer shuffleServer) {
        this.shuffleServer = shuffleServer;
        this.conf = shuffleServer.getShuffleServerConf();
    }

    public ServerInterface getServer() {
        ServerType type = (ServerType)this.conf.get(ShuffleServerConf.RPC_SERVER_TYPE);
        if (type == ServerType.GRPC || type == ServerType.GRPC_NETTY) {
            return GrpcServer.Builder.newBuilder().conf((RssBaseConf)this.conf).grpcMetrics(this.shuffleServer.getGrpcMetrics()).addService((BindableService)new ShuffleServerGrpcService(this.shuffleServer), new ServerInterceptor[0]).addService((BindableService)new ShuffleServerInternalGrpcService(this.shuffleServer), new ServerInterceptor[0]).build();
        }
        throw new UnsupportedOperationException("Unsupported server type " + type);
    }

    public ShuffleServer getShuffleServer() {
        return this.shuffleServer;
    }

    public ShuffleServerConf getConf() {
        return this.conf;
    }
}

