/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.configurator.impl.Configurator;
import org.apache.felix.configurator.impl.logger.SystemLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServicesListener {
    private final BundleContext bundleContext;
    private final ServiceTracker<ConfigurationAdmin, ServiceReference<ConfigurationAdmin>> caTracker;
    private final Listener coordinatorListener;
    private volatile Configurator configurator;
    private final List<ServiceReference<ConfigurationAdmin>> configAdminReferences;

    public ServicesListener(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.configAdminReferences = new ArrayList<ServiceReference<ConfigurationAdmin>>();
        this.caTracker = new ServiceTracker(bundleContext, ConfigurationAdmin.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ConfigurationAdmin, ServiceReference<ConfigurationAdmin>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ServiceReference<ConfigurationAdmin> addingService(ServiceReference<ConfigurationAdmin> reference) {
                List list = ServicesListener.this.configAdminReferences;
                synchronized (list) {
                    ServicesListener.this.configAdminReferences.add(reference);
                    Collections.sort(ServicesListener.this.configAdminReferences);
                }
                ServicesListener.this.notifyChange();
                return reference;
            }

            public void modifiedService(ServiceReference<ConfigurationAdmin> reference, ServiceReference<ConfigurationAdmin> service) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<ConfigurationAdmin> reference, ServiceReference<ConfigurationAdmin> service) {
                List list = ServicesListener.this.configAdminReferences;
                synchronized (list) {
                    ServicesListener.this.configAdminReferences.remove(reference);
                }
                ServicesListener.this.notifyChange();
            }
        });
        this.coordinatorListener = new Listener("org.osgi.service.coordinator.Coordinator");
        this.caTracker.open();
        this.coordinatorListener.start();
        SystemLogger.debug("Started services listener for configurator.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange() {
        List<ServiceReference<ConfigurationAdmin>> list = this.configAdminReferences;
        synchronized (list) {
            boolean hasConfigAdmin = !this.configAdminReferences.isEmpty();
            Object coordinator = this.coordinatorListener.getService();
            SystemLogger.debug("Services updated for configurator: " + this.configAdminReferences + " - " + coordinator);
            if (hasConfigAdmin) {
                boolean isNew;
                boolean bl = isNew = this.configurator == null;
                if (isNew) {
                    SystemLogger.debug("Starting new configurator");
                    this.configurator = new Configurator(this.bundleContext, this.configAdminReferences);
                }
                this.configurator.setCoordinator(coordinator);
                if (isNew) {
                    this.configurator.start();
                } else {
                    this.configurator.configAdminAdded();
                }
            } else if (this.configurator != null) {
                SystemLogger.debug("Stopping configurator");
                this.configurator.shutdown();
                this.configurator = null;
            }
        }
    }

    public void deactivate() {
        this.caTracker.close();
        this.coordinatorListener.deactivate();
        if (this.configurator != null) {
            this.configurator.shutdown();
            this.configurator = null;
        }
    }

    protected final class Listener
    implements ServiceListener {
        private final String serviceName;
        private volatile ServiceReference<?> reference;
        private volatile Object service;

        public Listener(String serviceName) {
            this.serviceName = serviceName;
        }

        public void start() {
            try {
                ServicesListener.this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + this.serviceName + ")");
            }
            catch (InvalidSyntaxException ise) {
                throw new RuntimeException("Unexpected exception occured.", ise);
            }
            this.retainService();
        }

        public void deactivate() {
            ServicesListener.this.bundleContext.removeServiceListener((ServiceListener)this);
        }

        public synchronized Object getService() {
            return this.service;
        }

        private synchronized void retainService() {
            if (this.reference == null) {
                this.reference = ServicesListener.this.bundleContext.getServiceReference(this.serviceName);
                if (this.reference != null) {
                    this.service = ServicesListener.this.bundleContext.getService(this.reference);
                    if (this.service == null) {
                        this.reference = null;
                    } else {
                        ServicesListener.this.notifyChange();
                    }
                }
            }
        }

        private synchronized void releaseService(ServiceReference<?> ref) {
            if (this.reference != null && this.reference.compareTo(ref) == 0) {
                this.service = null;
                ServicesListener.this.bundleContext.ungetService(this.reference);
                this.reference = null;
                ServicesListener.this.notifyChange();
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1) {
                this.retainService();
            } else if (event.getType() == 4) {
                this.releaseService(event.getServiceReference());
                this.retainService();
            }
        }
    }
}

