/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validation;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class SchemaReader {
    public static final String ACCESS_EXTERNAL_DTD = "CamelXmlValidatorAccessExternalDTD";
    private static final Logger LOG = LoggerFactory.getLogger(SchemaReader.class);
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private volatile Schema schema;
    private Source schemaSource;
    private volatile SchemaFactory schemaFactory;
    private URL schemaUrl;
    private File schemaFile;
    private byte[] schemaAsByteArray;
    private final String schemaResourceUri;
    private LSResourceResolver resourceResolver;
    private final CamelContext camelContext;

    public SchemaReader() {
        this.camelContext = null;
        this.schemaResourceUri = null;
    }

    public SchemaReader(CamelContext camelContext, String schemaResourceUri) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(schemaResourceUri, "schemaResourceUri");
        this.camelContext = camelContext;
        this.schemaResourceUri = schemaResourceUri;
    }

    public void loadSchema() throws Exception {
        this.schema = this.createSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema getSchema() throws IOException, SAXException {
        if (this.schema == null) {
            SchemaReader schemaReader = this;
            synchronized (schemaReader) {
                if (this.schema == null) {
                    this.schema = this.createSchema();
                }
            }
        }
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public Source getSchemaSource() throws IOException {
        if (this.schemaSource == null) {
            this.schemaSource = this.createSchemaSource();
        }
        return this.schemaSource;
    }

    public void setSchemaSource(Source schemaSource) {
        this.schemaSource = schemaSource;
    }

    public URL getSchemaUrl() {
        return this.schemaUrl;
    }

    public void setSchemaUrl(URL schemaUrl) {
        this.schemaUrl = schemaUrl;
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(File schemaFile) {
        this.schemaFile = schemaFile;
    }

    public byte[] getSchemaAsByteArray() {
        return this.schemaAsByteArray;
    }

    public void setSchemaAsByteArray(byte[] schemaAsByteArray) {
        this.schemaAsByteArray = schemaAsByteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaFactory getSchemaFactory() {
        if (this.schemaFactory == null) {
            SchemaReader schemaReader = this;
            synchronized (schemaReader) {
                if (this.schemaFactory == null) {
                    this.schemaFactory = this.createSchemaFactory();
                }
            }
        }
        return this.schemaFactory;
    }

    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    protected SchemaFactory createSchemaFactory() {
        SchemaFactory factory = SchemaFactory.newInstance(this.schemaLanguage);
        if (this.getResourceResolver() != null) {
            factory.setResourceResolver(this.getResourceResolver());
        }
        if (this.camelContext == null || !Boolean.parseBoolean(this.camelContext.getGlobalOptions().get(ACCESS_EXTERNAL_DTD))) {
            try {
                LOG.debug("Configuring SchemaFactory to not allow access to external DTD/Schema");
                factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            }
            catch (SAXException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return factory;
    }

    protected Source createSchemaSource() throws IOException {
        throw new IllegalArgumentException("You must specify either a schema, schemaFile, schemaSource, schemaUrl, or schemaUri property");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schema createSchema() throws SAXException, IOException {
        SchemaFactory factory = this.getSchemaFactory();
        URL url = this.getSchemaUrl();
        if (url != null) {
            SchemaReader schemaReader = this;
            synchronized (schemaReader) {
                return factory.newSchema(url);
            }
        }
        File file = this.getSchemaFile();
        if (file != null) {
            SchemaReader schemaReader = this;
            synchronized (schemaReader) {
                return factory.newSchema(file);
            }
        }
        byte[] bytes = this.getSchemaAsByteArray();
        if (bytes != null) {
            SchemaReader schemaReader = this;
            synchronized (schemaReader) {
                return factory.newSchema(new StreamSource(new ByteArrayInputStream(this.schemaAsByteArray)));
            }
        }
        if (this.schemaResourceUri != null) {
            SchemaReader schemaReader = this;
            synchronized (schemaReader) {
                bytes = this.readSchemaResource();
                return factory.newSchema(new StreamSource(new ByteArrayInputStream(bytes)));
            }
        }
        Source source = this.getSchemaSource();
        SchemaReader schemaReader = this;
        synchronized (schemaReader) {
            return factory.newSchema(source);
        }
    }

    protected byte[] readSchemaResource() throws IOException {
        LOG.debug("reading schema resource: {}", (Object)this.schemaResourceUri);
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.camelContext, this.schemaResourceUri);
        byte[] bytes = null;
        try {
            bytes = IOConverter.toBytes(is);
        }
        finally {
            IOHelper.close((Closeable)is);
        }
        return bytes;
    }
}

