/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.cdi;

import jakarta.enterprise.context.Conversation;
import jakarta.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.application.IComponentOnBeforeRenderListener;
import org.apache.wicket.cdi.ConversationExpiredException;
import org.apache.wicket.cdi.ConversationPropagator;
import org.apache.wicket.cdi.NonContextual;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.lang.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationExpiryChecker
implements IComponentOnBeforeRenderListener {
    private static final Logger logger = LoggerFactory.getLogger(ConversationExpiryChecker.class);
    @Inject
    private Conversation conversation;

    public ConversationExpiryChecker() {
        NonContextual.of(ConversationExpiryChecker.class).inject(this);
    }

    public void onBeforeRender(Component component) {
        Page page;
        String cid;
        if ((component instanceof Page || RequestCycle.get().find(IPartialPageRequestHandler.class).isPresent()) && (cid = ConversationPropagator.getConversationIdFromPage(page = component.getPage())) != null && !Objects.isEqual((Object)this.conversation.getId(), (Object)cid)) {
            logger.info("Conversation {} has expired for {}", (Object)cid, (Object)page);
            throw new ConversationExpiredException(null, cid, page, RequestCycle.get().getActiveRequestHandler());
        }
    }
}

